/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Base64Utils {
    public static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    public static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    private Base64Utils() {
    }

    public static String buildStr(byte[] src) {
        if (src == null) {
            return null;
        }
        return new String(src, 0, src.length, StandardCharsets.UTF_8);
    }

    public static byte[] encode(byte[] src) {
        if (src == null) {
            return null;
        }
        return BASE64_ENCODER.encode(src);
    }

    public static byte[] encode(String src) {
        if (src == null) {
            return null;
        }
        return BASE64_ENCODER.encode(src.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeToString(byte[] src) {
        byte[] encoded = Base64Utils.encode(src);
        return Base64Utils.buildStr(encoded);
    }

    public static String encodeToString(String src) {
        byte[] encoded = Base64Utils.encode(src);
        return Base64Utils.buildStr(encoded);
    }

    public static byte[] decode(byte[] src) {
        return BASE64_DECODER.decode(src);
    }

    public static byte[] decode(String src) {
        return BASE64_DECODER.decode(src);
    }

    public static String decodeToString(byte[] src) {
        byte[] decode = Base64Utils.decode(src);
        return Base64Utils.buildStr(decode);
    }

    public static String decodeToString(String src) {
        byte[] decode = Base64Utils.decode(src);
        return Base64Utils.buildStr(decode);
    }
}

