/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Objects;

public class DateUtils {
    public static final ZoneId ZONE_ID = ZoneId.systemDefault();
    public static final DateTimeFormatter SIMPLE_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_PATTERN = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_CN_PATTERN = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
    public static final DateTimeFormatter MILLI_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter FILE_STORE_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy/MM/dd");

    private DateUtils() {
    }

    public static DateTimeFormatter getFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZONE_ID).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZONE_ID).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZONE_ID).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(int timestamp) {
        return DateUtils.toLocalDateTime(new Date((long)timestamp * 1000L));
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate, LocalTime localTime) {
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        if (localTime == null) {
            localTime = LocalTime.now();
        }
        return localDate.atTime(localTime);
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZONE_ID).toInstant());
    }

    public static Date toDate(LocalTime localTime) {
        return DateUtils.toDate(null, localTime);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZONE_ID).toInstant());
    }

    public static Date toDate(LocalDate localDate, LocalTime localTime) {
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        if (localTime == null) {
            localTime = LocalTime.MIN;
        }
        return Date.from(localDate.atTime(localTime).atZone(ZONE_ID).toInstant());
    }

    public static LocalDateTime getDayStart(LocalDate localDate) {
        return DateUtils.toLocalDateTime(localDate, LocalTime.MIN);
    }

    public static LocalDateTime getDayEnd(LocalDate localDate) {
        return DateUtils.toLocalDateTime(localDate, LocalTime.MAX);
    }

    public static LocalDate getDay(int offset) {
        return LocalDate.now().plusDays(offset);
    }

    public static LocalDate getWeekStart(int offset) {
        return LocalDate.now().plusWeeks(offset).with(DayOfWeek.MONDAY);
    }

    public static LocalDate getWeekEnd(int offset) {
        return LocalDate.now().plusWeeks(offset).with(DayOfWeek.SUNDAY);
    }

    public static LocalDate getMonthStart(int offset) {
        return LocalDate.now().plusMonths(offset).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getMonthEnd(int offset) {
        return LocalDate.now().plusMonths(offset).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getQuarterStart(int offset) {
        LocalDate date = LocalDate.now().plusMonths((long)offset * 3L);
        int month = date.getMonth().getValue();
        int start = DateUtils.getQuarterMonth(month, true);
        return date.plusMonths(start - month).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getQuarterEnd(int offset) {
        LocalDate date = LocalDate.now().plusMonths((long)offset * 3L);
        int month = date.getMonth().getValue();
        int end = DateUtils.getQuarterMonth(month, false);
        return date.plusMonths(end - month).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getYearStart(int offset) {
        return LocalDate.now().plusYears(offset).with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate getYearEnd(int offset) {
        return LocalDate.now().plusYears(offset).with(TemporalAdjusters.lastDayOfYear());
    }

    public static int getQuarterMonth(int currentMonth, boolean start) {
        int result;
        switch (currentMonth) {
            case 1: 
            case 2: 
            case 3: {
                result = start ? 1 : 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                result = start ? 4 : 6;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                result = start ? 7 : 9;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                result = start ? 10 : 12;
                break;
            }
            default: {
                result = currentMonth;
            }
        }
        return result;
    }

    public static int toEpochSecond(LocalDateTime localDateTime) {
        return (int)localDateTime.atZone(ZONE_ID).toEpochSecond();
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZONE_ID).toInstant().toEpochMilli();
    }

    public static int now() {
        return DateUtils.toEpochSecond(LocalDateTime.now());
    }

    public static int todayStart() {
        return DateUtils.toEpochSecond(DateUtils.getDayStart(LocalDate.now()));
    }

    public static int todayEnd() {
        return DateUtils.toEpochSecond(DateUtils.getDayEnd(LocalDate.now()));
    }

    public static int weekStart() {
        return DateUtils.toEpochSecond(DateUtils.getDayStart(DateUtils.getWeekStart(0)));
    }

    public static int weekEnd() {
        return DateUtils.toEpochSecond(DateUtils.getDayEnd(DateUtils.getWeekEnd(0)));
    }

    public static int monthStart() {
        return DateUtils.toEpochSecond(DateUtils.getDayStart(DateUtils.getMonthStart(0)));
    }

    public static int monthEnd() {
        return DateUtils.toEpochSecond(DateUtils.getDayEnd(DateUtils.getMonthEnd(0)));
    }

    public static int quarterStart() {
        return DateUtils.toEpochSecond(DateUtils.getDayStart(DateUtils.getQuarterStart(0)));
    }

    public static int quarterEnd() {
        return DateUtils.toEpochSecond(DateUtils.getDayEnd(DateUtils.getQuarterEnd(0)));
    }

    public static int yearStart() {
        return DateUtils.toEpochSecond(DateUtils.getDayStart(DateUtils.getYearStart(0)));
    }

    public static int yearEnd() {
        return DateUtils.toEpochSecond(DateUtils.getDayEnd(DateUtils.getYearEnd(0)));
    }

    public static LocalDate parseDate(String date) {
        return LocalDate.parse(date, DATE_PATTERN);
    }

    public static String formatDate(LocalDate date) {
        return date.format(DATE_PATTERN);
    }

    public static LocalTime parseTime(String time) {
        return LocalTime.parse(time, TIME_PATTERN);
    }

    public static String formatTime(LocalTime time) {
        return time.format(TIME_PATTERN);
    }

    public static LocalDateTime parseDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DATE_TIME_PATTERN);
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        return dateTime.format(DATE_TIME_PATTERN);
    }

    public static long betweenDays(LocalDate begin, LocalDate end) {
        Objects.requireNonNull(begin, "begin");
        Objects.requireNonNull(end, "end");
        return end.toEpochDay() - begin.toEpochDay();
    }

    public static long betweenMonths(LocalDate begin, LocalDate end) {
        Objects.requireNonNull(begin, "begin");
        Objects.requireNonNull(end, "end");
        int beginYear = begin.getYear();
        int endYear = end.getYear();
        int startMonth = begin.getMonthValue();
        int endMonth = end.getMonthValue();
        return (long)(endYear - beginYear) * 12L + (long)endMonth - (long)startMonth;
    }

    public static long betweenYears(LocalDate begin, LocalDate end) {
        Objects.requireNonNull(begin, "begin");
        Objects.requireNonNull(end, "end");
        return end.getYear() - begin.getYear();
    }

    public static String nowForFileStore() {
        return LocalDate.now().format(FILE_STORE_DATE_PATTERN);
    }
}

