/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.httpclient;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.BaseException;
import cn.ziyicloud.framework.boot.util.httpclient.builder.HttpClientBuilderUtil;
import cn.ziyicloud.framework.boot.util.httpclient.config.HttpConfig;
import cn.ziyicloud.framework.boot.util.httpclient.model.HttpMethod;
import cn.ziyicloud.framework.boot.util.httpclient.request.HttpDeleteWithBody;
import cn.ziyicloud.framework.boot.util.httpclient.util.HttpUrlUtils;
import cn.ziyicloud.framework.boot.util.httpclient.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final int WAIT_TIMEOUT = 60000;
    public static final int MAX_TOTAL_CONNECTIONS = 800;
    public static final int MAX_ROUTE_CONNECTIONS = 400;
    public static final int CONNECT_TIMEOUT = 10000;
    public static final int READ_TIMEOUT = 10000;
    private static HttpClient client4HTTP;
    private static HttpClient client4HTTPS;

    private HttpClientUtil() {
    }

    private static void create(HttpConfig config) {
        if (config.client() == null) {
            if (config.url().toLowerCase().startsWith("https://")) {
                config.client(client4HTTPS);
            } else {
                config.client(client4HTTP);
            }
        }
    }

    public static String get(String url) {
        return HttpClientUtil.get(HttpConfig.custom().url(url));
    }

    public static String get(String url, Map<String, String> parameters) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(url);
        if (HttpUrlUtils.checkHasParamters(url)) {
            stringBuffer.append("&");
        } else {
            stringBuffer.append("?");
        }
        stringBuffer.append(HttpUrlUtils.buildParameters(parameters));
        return HttpClientUtil.get(HttpConfig.custom().url(stringBuffer.toString()));
    }

    public static String get(String url, Header[] headers) {
        return HttpClientUtil.get(HttpConfig.custom().url(url).headers(headers));
    }

    public static String get(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.get(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String get(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.GET));
    }

    public static String post(String url, String jsonParam, Header[] headers) {
        return HttpClientUtil.post(HttpConfig.custom().url(url).json(jsonParam).headers(headers));
    }

    public static String post(HttpClient client, String url, Header[] headers, Map<String, Object> parasMap, HttpContext context, String encoding) {
        return HttpClientUtil.post(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String post(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.POST));
    }

    public static String put(String url, String jsonParam, Header[] headers) {
        return HttpClientUtil.put(HttpConfig.custom().url(url).json(jsonParam).headers(headers));
    }

    public static String put(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.put(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String put(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.PUT));
    }

    public static String delete(String url, Header[] headers) {
        return HttpClientUtil.delete(HttpConfig.custom().url(url).headers(headers));
    }

    public static String delete(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.delete(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String delete(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.DELETE));
    }

    public static String patch(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.patch(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String patch(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.PATCH));
    }

    public static String head(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.head(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String head(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.HEAD));
    }

    public static String options(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.options(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String options(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.OPTIONS));
    }

    public static String trace(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) {
        return HttpClientUtil.trace(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String trace(HttpConfig config) {
        return HttpClientUtil.send(config.method(HttpMethod.TRACE));
    }

    public static byte[] down(String url) {
        HttpConfig config = HttpConfig.custom().url(url).method(HttpMethod.GET);
        return HttpClientUtil.format2bytes(HttpClientUtil.execute(config));
    }

    public static OutputStream down(String url, OutputStream out, Header[] headers) {
        return HttpClientUtil.down(HttpConfig.custom().headers(headers).out(out).url(url));
    }

    public static OutputStream down(HttpClient client, String url, Header[] headers, HttpContext context, OutputStream out) {
        return HttpClientUtil.down(HttpConfig.custom().client(client).url(url).headers(headers).context(context).out(out));
    }

    public static OutputStream down(HttpConfig config) {
        if (config.method() == null) {
            config.method(HttpMethod.GET);
        }
        return HttpClientUtil.format2Stream(HttpClientUtil.execute(config), config.out());
    }

    public static String upload(HttpClient client, String url, Header[] headers, HttpContext context) {
        return HttpClientUtil.upload(HttpConfig.custom().client(client).url(url).headers(headers).context(context));
    }

    public static String upload(HttpConfig config) {
        if (config.method() != HttpMethod.POST && config.method() != HttpMethod.PUT) {
            config.method(HttpMethod.POST);
        }
        return HttpClientUtil.send(config);
    }

    public static int status(HttpClient client, String url, Header[] headers, HttpContext context, HttpMethod method) {
        return HttpClientUtil.status(HttpConfig.custom().client(client).url(url).headers(headers).context(context).method(method));
    }

    public static int status(HttpConfig config) {
        return HttpClientUtil.format2Int(HttpClientUtil.execute(config));
    }

    public static String send(HttpConfig config) {
        return HttpClientUtil.format2String(HttpClientUtil.execute(config), config.outenc());
    }

    private static HttpResponse execute(HttpConfig config) {
        HttpClientUtil.create(config);
        try {
            HttpResponse httpResponse;
            HttpRequestBase request = HttpClientUtil.getRequest(config.url(), config.method());
            request.setHeaders(config.headers());
            if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(request.getClass())) {
                ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                config.url(Utils.checkHasParas(config.url(), nvps, config.inenc()));
                HttpEntity entity = Utils.map2HttpEntity(nvps, config.map(), config.inenc());
                ((HttpEntityEnclosingRequestBase)request).setEntity(entity);
                log.debug("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url());
                if (nvps.size() > 0) {
                    log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a" + ((Object)nvps).toString());
                }
                if (config.json() != null) {
                    log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.json());
                }
            } else {
                int idx = config.url().indexOf("?");
                log.debug("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url().substring(0, idx > 0 ? idx : config.url().length()));
                if (idx > 0) {
                    log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.url().substring(idx + 1));
                }
            }
            HttpResponse httpResponse2 = httpResponse = config.context() == null ? config.client().execute((HttpUriRequest)request) : config.client().execute((HttpUriRequest)request, config.context());
            if (config.isReturnRespHeaders()) {
                config.headers(httpResponse.getAllHeaders());
            }
            return httpResponse;
        }
        catch (IOException e) {
            throw new BaseException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
    }

    private static String format2String(HttpResponse httpResponse, String encoding) {
        String body;
        try {
            if (httpResponse.getEntity() != null) {
                body = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)encoding);
                log.debug(body);
            } else {
                body = httpResponse.getStatusLine().toString();
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            throw new BaseException(ErrorCodeEnum.HTTP_ERROR, "http\u8bf7\u6c42\u8f6c\u5316\u4e3a\u5b57\u7b26\u4e32\u51fa\u9519", (Throwable)e);
        }
        finally {
            HttpClientUtil.close(httpResponse);
        }
        return body;
    }

    private static int format2Int(HttpResponse httpResponse) {
        int statusCode;
        try {
            statusCode = httpResponse.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            throw new BaseException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        finally {
            HttpClientUtil.close(httpResponse);
        }
        return statusCode;
    }

    public static OutputStream format2Stream(HttpResponse httpResponse, OutputStream out) {
        try {
            httpResponse.getEntity().writeTo(out);
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            throw new BaseException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        finally {
            HttpClientUtil.close(httpResponse);
        }
        return out;
    }

    public static byte[] format2bytes(HttpResponse httpResponse) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            InputStream inStream = httpResponse.getEntity().getContent();
            byte[] buffer = new byte[4096];
            while (-1 != (n = inStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            throw new BaseException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        finally {
            HttpClientUtil.close(httpResponse);
        }
        return output.toByteArray();
    }

    private static HttpRequestBase getRequest(String url, HttpMethod method) {
        Object request;
        switch (method.getCode()) {
            case 0: {
                request = new HttpGet(url);
                break;
            }
            case 1: {
                request = new HttpPost(url);
                break;
            }
            case 2: {
                request = new HttpHead(url);
                break;
            }
            case 3: {
                request = new HttpPut(url);
                break;
            }
            case 4: {
                request = new HttpDeleteWithBody(url);
                break;
            }
            case 5: {
                request = new HttpTrace(url);
                break;
            }
            case 6: {
                request = new HttpPatch(url);
                break;
            }
            case 7: {
                request = new HttpOptions(url);
                break;
            }
            default: {
                request = new HttpPost(url);
            }
        }
        return request;
    }

    private static void close(HttpResponse httpResponse) {
        try {
            if (httpResponse == null) {
                return;
            }
            if (CloseableHttpResponse.class.isAssignableFrom(httpResponse.getClass())) {
                ((CloseableHttpResponse)httpResponse).close();
            }
        }
        catch (IOException e) {
            log.debug("\u5c1d\u8bd5\u5173\u95edresponse\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    static {
        try {
            client4HTTP = HttpClientBuilderUtil.custom().pool(800, 400).timeout(60000).build();
            client4HTTPS = HttpClientBuilderUtil.custom().pool(800, 400).timeout(60000).ssl().build();
        }
        catch (BaseException e) {
            log.debug("\u521b\u5efahttps\u534f\u8bae\u7684HttpClient\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
        }
    }
}

