/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.httpclient.config;

import cn.ziyicloud.framework.boot.util.httpclient.model.HttpMethod;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpConfig {
    private HttpClient client;
    private Header[] headers;
    private boolean isReturnRespHeaders;
    private HttpMethod method = HttpMethod.GET;
    private String methodName;
    private HttpContext context;
    private Map<String, Object> map;
    private String json;
    private String encoding = StandardCharsets.UTF_8.displayName();
    private String inenc;
    private String outenc;
    private static final ThreadLocal<OutputStream> outs = new ThreadLocal();
    private static final ThreadLocal<String> urls = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> maps = new ThreadLocal();

    private HttpConfig() {
    }

    public static HttpConfig custom() {
        return new HttpConfig();
    }

    public HttpConfig client(HttpClient client) {
        this.client = client;
        return this;
    }

    public HttpConfig url(String url) {
        urls.set(url);
        return this;
    }

    public HttpConfig headers(Header[] headers) {
        this.headers = headers;
        return this;
    }

    public HttpConfig headers(Header[] headers, boolean isReturnRespHeaders) {
        this.headers = headers;
        this.isReturnRespHeaders = isReturnRespHeaders;
        return this;
    }

    public HttpConfig method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpConfig methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public HttpConfig context(HttpContext context) {
        this.context = context;
        return this;
    }

    public HttpConfig map(Map<String, Object> map) {
        if (map != null) {
            Map<String, Object> localMap = maps.get();
            if (localMap == null) {
                localMap = map;
            } else {
                localMap.putAll(map);
            }
            maps.set(localMap);
        }
        return this;
    }

    public HttpConfig json(String json) {
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            this.json = json;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("$ENTITY_STRING$", json);
            maps.set(map);
        }
        return this;
    }

    public HttpConfig file(String filePath) {
        Map<String, Object> m = maps.get();
        if (m == null) {
            m = new HashMap<String, Object>();
        }
        m.put("$ENTITY_FILEE$", filePath);
        maps.set(m);
        return this;
    }

    public HttpConfig files(String[] filePaths) {
        return this.files(filePaths, "file");
    }

    public HttpConfig files(String[] filePaths, String inputName) {
        return this.files(filePaths, inputName, false);
    }

    public HttpConfig files(String[] filePaths, String inputName, boolean forceRemoveContentTypeChraset) {
        Map<String, Object> m = maps.get();
        if (m == null) {
            m = new HashMap<String, Object>();
        }
        m.put("$ENTITY_MULTIPART$", filePaths);
        m.put("$ENTITY_MULTIPART$.name", inputName);
        m.put("$ENTITY_MULTIPART$.rmCharset", forceRemoveContentTypeChraset);
        maps.set(m);
        return this;
    }

    public HttpConfig encoding(String encoding) {
        this.inenc(encoding);
        this.outenc(encoding);
        this.encoding = encoding;
        return this;
    }

    public HttpConfig inenc(String inenc) {
        this.inenc = inenc;
        return this;
    }

    public HttpConfig outenc(String outenc) {
        this.outenc = outenc;
        return this;
    }

    public HttpConfig out(OutputStream out) {
        outs.set(out);
        return this;
    }

    public HttpClient client() {
        return this.client;
    }

    public Header[] headers() {
        return this.headers;
    }

    public boolean isReturnRespHeaders() {
        return this.isReturnRespHeaders;
    }

    public String url() {
        return urls.get();
    }

    public HttpMethod method() {
        return this.method;
    }

    public String methodName() {
        return this.methodName;
    }

    public HttpContext context() {
        return this.context;
    }

    public Map<String, Object> map() {
        return maps.get();
    }

    public String json() {
        return this.json;
    }

    public String encoding() {
        return this.encoding;
    }

    public String inenc() {
        return this.inenc == null ? this.encoding : this.inenc;
    }

    public String outenc() {
        return this.outenc == null ? this.encoding : this.outenc;
    }

    public OutputStream out() {
        return outs.get();
    }
}

