/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.string;

public class CamelCaseConversion {
    private static final String EMPTY = "";
    private static final String SPACE_CASE_SEPARATOR = " ";
    private static final String SNAKE_CASE_SEPARATOR = "_";
    private static final String KEBAB_CASE_SEPARATOR = "-";

    private CamelCaseConversion() {
    }

    public static String toSnakeCase(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(EMPTY + Character.toLowerCase(in.charAt(0)));
        for (int i = 1; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append(SNAKE_CASE_SEPARATOR).append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String toUpperSnakeCase(String in) {
        return CamelCaseConversion.toSnakeCase(in).toUpperCase();
    }

    public static String toKebabCase(String in) {
        String snakeCased = CamelCaseConversion.toSnakeCase(in);
        return snakeCased.replace(SNAKE_CASE_SEPARATOR, KEBAB_CASE_SEPARATOR);
    }

    public static String toSpaceCase(String in) {
        String snakeCased = CamelCaseConversion.toSnakeCase(in);
        return snakeCased.replace(SNAKE_CASE_SEPARATOR, SPACE_CASE_SEPARATOR);
    }

    public static String toPascalCase(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder pascalCase = new StringBuilder();
        String[] tokens = in.split(SNAKE_CASE_SEPARATOR);
        int var4 = tokens.length;
        for (String token : tokens) {
            if (token.length() >= 1) {
                pascalCase.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
                continue;
            }
            pascalCase.append(SNAKE_CASE_SEPARATOR);
        }
        return pascalCase.toString();
    }

    public static String toCamelCase(String in) {
        String pascalCase = CamelCaseConversion.toPascalCase(in);
        return pascalCase.substring(0, 1).toLowerCase() + pascalCase.substring(1);
    }
}

