/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.wx;

import cn.ziyicloud.framework.boot.exception.BaseException;
import cn.ziyicloud.framework.boot.util.crypto.Base64Utils;
import cn.ziyicloud.framework.boot.util.httpclient.HttpClientUtil;
import cn.ziyicloud.framework.boot.util.json.JsonUtils;
import cn.ziyicloud.framework.boot.util.wx.WechatJsCode2SessionResult;
import cn.ziyicloud.framework.boot.util.wx.WechatUserInfo;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechartUtils {
    private static final Logger log = LoggerFactory.getLogger(WechartUtils.class);
    public static final String JS_CODE_TO_SESSION = "https://api.weixin.qq.com/sns/jscode2session";
    public static final String GRANT_TYPE = "authorization_code";

    private WechartUtils() {
    }

    public static WechatUserInfo decrypt(String sessionKey, String encryptedData, String iv) {
        byte[] key = Base64Utils.decode(sessionKey);
        byte[] data = Base64Utils.decode(encryptedData);
        byte[] ivKey = Base64Utils.decode(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(ivKey);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            cipher.init(2, (Key)keySpec, ivSpec);
            return JsonUtils.parse(new String(cipher.doFinal(data), StandardCharsets.UTF_8), WechatUserInfo.class);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (log.isDebugEnabled()) {
                log.debug("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            }
            return null;
        }
    }

    public static String getWxSessionKey(String appId, String appSecret, String jsCode) {
        String result;
        block2: {
            result = null;
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("appid", appId);
            params.put("secret", appSecret);
            params.put("js_code", jsCode);
            params.put("grant_type", GRANT_TYPE);
            try {
                String res = HttpClientUtil.get(JS_CODE_TO_SESSION, params);
                WechatJsCode2SessionResult wechatJsCode2SessionResult = JsonUtils.parse(res, WechatJsCode2SessionResult.class);
                result = wechatJsCode2SessionResult.getSessionKey();
            }
            catch (BaseException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6sessionKey\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }
}

