/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.feature.flag;

import cn.zzq0324.feature.flag.FeatureFlagInstance;
import cn.zzq0324.feature.flag.FeatureFlagInstanceRegister;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagHelper {
    private static Logger logger = LoggerFactory.getLogger(FeatureFlagHelper.class);
    private static Map<String, FeatureFlagInstance> FLAG_MAP = new ConcurrentHashMap<String, FeatureFlagInstance>();

    public static boolean isFeatureOn(String flagName, String bizId) {
        try {
            FeatureFlagInstance instance = FeatureFlagHelper.getFeatureFlagInstance(flagName);
            return instance.isFeatureOn(bizId);
        }
        catch (Exception e) {
            logger.error("flagName: {}, bizId: {} get feature flag error.", new Object[]{flagName, bizId, e});
            return false;
        }
    }

    public static FeatureFlagInstance getFeatureFlagInstance(String flagName) {
        return FLAG_MAP.computeIfAbsent(flagName, k -> FeatureFlagInstanceRegister.registerIfNotExist(k));
    }

    public static boolean isFeatureOn(String flagName) {
        return FeatureFlagHelper.isFeatureOn(flagName, null);
    }
}

