/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.feature.flag;

import cn.zzq0324.feature.flag.algorithm.FNV;
import cn.zzq0324.feature.flag.util.DateUtils;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class FeatureFlagInstance {
    private static Logger logger = LoggerFactory.getLogger(FeatureFlagInstance.class);
    protected String flagName;

    public FeatureFlagInstance(String flagName) {
        this.flagName = flagName;
    }

    public String getFlagName() {
        return this.flagName;
    }

    protected abstract String getDesc();

    protected abstract Set<String> getWhiteSet();

    protected abstract Set<String> getBlackSet();

    public abstract int getLaunchPercent();

    public abstract long getStartTime();

    public abstract long getEndTime();

    public abstract String getExtra();

    public boolean isFeatureOn(String bizId) {
        if (!this.isInTimeSection()) {
            return false;
        }
        if (this.isInBlackList(bizId)) {
            return false;
        }
        if (this.isInWhiteList(bizId)) {
            return true;
        }
        if (this.getLaunchPercent() == 0) {
            return false;
        }
        if (this.getLaunchPercent() == 100) {
            return true;
        }
        long hash = 0L;
        hash = bizId == null ? (long)ThreadLocalRandom.current().nextInt(100) : this.seededHash(bizId);
        return hash < (long)this.getLaunchPercent();
    }

    protected boolean isInWhiteList(String bizId) {
        return this.isContain(this.getWhiteSet(), bizId);
    }

    protected boolean isInBlackList(String bizId) {
        return this.isContain(this.getBlackSet(), bizId);
    }

    protected boolean isInTimeSection() {
        Date now = new Date();
        return now.getTime() >= this.getStartTime() && now.getTime() <= this.getEndTime();
    }

    protected boolean isContain(Collection<String> list, String bizId) {
        return !CollectionUtils.isEmpty(list) && list.contains(bizId);
    }

    protected long seededHash(String bizId) {
        long seed = FNV.fnv1a_32(this.getFlagName());
        long h = seed % 100L;
        byte[] bytes = bizId.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            int t = 0xFF & bytes[i];
            h = (h * 31L + (long)t) % 100L;
        }
        return h;
    }

    protected Date parseTime(String text) {
        if (StringUtils.isEmpty((Object)text)) {
            return null;
        }
        try {
            return DateUtils.parse(text);
        }
        catch (ParseException e) {
            logger.error("parse time error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

