/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.feature.flag;

import cn.zzq0324.feature.flag.FeatureFlagInstance;
import cn.zzq0324.feature.flag.spring.SpringContextHolder;
import cn.zzq0324.feature.flag.support.JdkCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class FeatureFlagInstanceRegister {
    private static Logger logger = LoggerFactory.getLogger(FeatureFlagInstanceRegister.class);
    private static String FEATURE_FLAG_TPL_PATH = "generator/FeatureFlagInstance.tpl";

    public static FeatureFlagInstance registerIfNotExist(String flagName) {
        if (!FeatureFlagInstanceRegister.isContainsBean(flagName)) {
            try {
                FeatureFlagInstanceRegister.dynamicLoadClassAndRegisterBean(flagName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("dynamicLoadClassAndRegisterBean error", e);
            }
        }
        FeatureFlagInstance instance = FeatureFlagInstanceRegister.getInstanceFromSpringContext(flagName);
        return instance;
    }

    private static synchronized void dynamicLoadClassAndRegisterBean(String flagName) throws IOException, ClassNotFoundException {
        if (FeatureFlagInstanceRegister.isContainsBean(flagName)) {
            return;
        }
        Class<? extends FeatureFlagInstance> beanType = FeatureFlagInstanceRegister.compileAndLoadClass(flagName);
        FeatureFlagInstanceRegister.registerBean(flagName, beanType);
        logger.info("register bean for flag: {} successfully.", (Object)flagName);
    }

    protected static Class<? extends FeatureFlagInstance> compileAndLoadClass(String flagName) throws IOException, ClassNotFoundException {
        String sourceTemplate = FeatureFlagInstanceRegister.loadSourceTemplate();
        String className = FeatureFlagInstanceRegister.flagNameToClassName(flagName);
        String source = sourceTemplate.replace("$flagName", flagName);
        source = source.replace("$className", className);
        logger.info("flag: {} source as follow: \n{}", (Object)flagName, (Object)source);
        Class beanType = JdkCompiler.compile(FeatureFlagInstance.class.getPackage().getName(), className, source);
        logger.info("compile and load class[{}] for flag: {} successfully.", (Object)beanType.getName(), (Object)flagName);
        return beanType;
    }

    private static void registerBean(String flagName, Class<? extends FeatureFlagInstance> beanType) {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringContextHolder.getApplicationContext();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanType);
        beanDefinitionBuilder.addConstructorArgValue((Object)flagName);
        beanFactory.registerBeanDefinition(flagName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    protected static String loadSourceTemplate() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(FEATURE_FLAG_TPL_PATH);
        try (InputStream is = classPathResource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)is, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    protected static String flagNameToClassName(String flagName) {
        flagName = flagName.replaceAll("-", "_");
        return flagName;
    }

    protected static FeatureFlagInstance getInstanceFromSpringContext(String flagName) {
        return (FeatureFlagInstance)SpringContextHolder.getApplicationContext().getBean(flagName, FeatureFlagInstance.class);
    }

    protected static boolean isContainsBean(String flagName) {
        return SpringContextHolder.getApplicationContext().containsBean(flagName);
    }
}

