package cn.zzq0324.radish.data.mybatis.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * 修改实体(有修改必有创建，包含创建人和创建时间)
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public abstract class UpdateEntity<T> extends CreateEntity<T> {

  /**
   * 修改人
   */
  @TableField("modifier")
  private Long modifier;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.UPDATE, value = "update_time")
  protected LocalDateTime updateTime;
}
