/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.docs;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class OpenApiAutoConfigurationProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.isEnableAutoConfig(environment.getActiveProfiles())) {
            System.setProperty("springdoc.api-docs.enabled", "false");
            System.setProperty("springdoc.swagger-ui.enabled", "false");
        }
    }

    private boolean isEnableAutoConfig(String[] activeProfiles) {
        if (activeProfiles == null || activeProfiles.length == 0) {
            return false;
        }
        List<String> activeProfileList = Arrays.asList(activeProfiles);
        return activeProfileList.contains("dev") || activeProfileList.contains("fat");
    }
}

