package cn.zzq0324.radish.components.docs;

import cn.zzq0324.radish.common.constant.ProfileConstants;
import java.util.Arrays;
import java.util.List;
import org.springdoc.core.Constants;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * OpenAPI自动配置控制，根据profile重写springdoc.api-docs.enabled的配置
 *
 * @author zzq0324
 * @since : 1.0.0
 */
public class DocAutoConfigurationProcessor implements EnvironmentPostProcessor {

  @Override
  public void postProcessEnvironment(ConfigurableEnvironment environment,
      SpringApplication application) {
    // 不需要自动配置，关闭apidocs和swagger-ui
    if (!isEnableAutoConfig(environment.getActiveProfiles())) {
      System.setProperty(Constants.SPRINGDOC_ENABLED, "false");
      System.setProperty(Constants.SPRINGDOC_SWAGGER_UI_ENABLED, "false");
    }
  }

  /**
   * 判断是否自动配置，只有dev环境和fat环境才需要自动配置
   */
  private boolean isEnableAutoConfig(String[] activeProfiles) {
    if (activeProfiles == null || activeProfiles.length == 0) {
      return false;
    }

    List<String> activeProfileList = Arrays.asList(activeProfiles);

    return activeProfileList.contains(ProfileConstants.DEV) || activeProfileList.contains(ProfileConstants.FAT);
  }
}
