/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.docs;

import cn.zzq0324.radish.components.docs.DocProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@Profile(value={"dev", "fat"})
public class OpenAPIConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIConfiguration.class);
    @Autowired
    private Environment properties;

    @Bean
    @ConfigurationProperties(value="radish.doc")
    public DocProperties docProperties() {
        return new DocProperties();
    }

    @Bean
    public ModelResolver modelResolver(@Autowired(required=false) ObjectMapper objectMapper) {
        return new ModelResolver(objectMapper != null ? objectMapper : new ObjectMapper());
    }

    @Bean
    public OpenAPI openAPI(DocProperties docProperties) {
        OpenAPI openAPI = new OpenAPI(SpecVersion.V30).info(this.apiInfo(docProperties));
        if (StringUtils.hasLength((String)docProperties.getAuthHeader())) {
            openAPI.components(this.securityComponents(docProperties));
        }
        return openAPI;
    }

    private Info apiInfo(DocProperties docProperties) {
        Info info = new Info();
        info.setTitle(docProperties.getTitle());
        info.setDescription(docProperties.getDescription());
        info.setVersion(docProperties.getVersion());
        if (docProperties.getContact() != null) {
            Contact contact = new Contact();
            contact.setName(docProperties.getContact().getName());
            contact.setUrl(docProperties.getContact().getUrl());
            contact.setEmail(docProperties.getContact().getEmail());
            info.setContact(contact);
        }
        return info;
    }

    private Components securityComponents(DocProperties docProperties) {
        Components components = new Components();
        Set headers = StringUtils.commaDelimitedListToSet((String)docProperties.getAuthHeader());
        for (String header : headers) {
            components.addSecuritySchemes(header, new SecurityScheme().type(SecurityScheme.Type.APIKEY).description(header).in(SecurityScheme.In.HEADER).name(header));
        }
        return components;
    }
}

