package cn.zzq0324.radish.components.http;

import cn.zzq0324.radish.common.util.MessageConvertUtils;
import cn.zzq0324.radish.components.http.util.RequestUtils;
import java.io.IOException;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Radish Http工具类
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Slf4j
public class RadishHttpClient {

  private OkHttpClient okHttpClient;

  public RadishHttpClient(OkHttpClient okHttpClient) {
    this.okHttpClient = okHttpClient;
  }

  /**
   * 仅仅调用，不需要接收返回数据
   */
  public void call(Request request) {
    call(request, Void.class);
  }

  /**
   * 同步调用
   */
  public <T> T call(Request request, Class<T> responseType) {
    Response response = null;

    try {
      // 同步调用
      response = okHttpClient.newCall(request).execute();

      // Response.isSuccessful() returns true if the code is in [200..300)
      if (!response.isSuccessful()) {
        throw new RuntimeException("url: " + RequestUtils.getUrl(request) + " fail, status code: " + response.code());
      }

      String responseData = response.body().string();

      return MessageConvertUtils.convert(responseData, responseType);
    } catch (IOException e) {
      log.error("invoke url: {} error", RequestUtils.getUrl(request), e);

      throw new RuntimeException(e);
    } finally {
      if (response != null) {
        response.close();
      }
    }
  }
}
