package cn.zzq0324.radish.components.http.configuration;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.OkHttpClient.Builder;

/**
 * OkHttpClient工厂类
 *
 * @author  zzq0324
 * @since : 1.0.0
 */
@Slf4j
public class OkHttpClientFactory {

  public OkHttpClient.Builder createBuilder(boolean disableSslValidation) {
    OkHttpClient.Builder builder = new Builder();
    if (disableSslValidation) {
      try {
        X509TrustManager disabledTrustManager = new DisableValidationTrustManager();
        TrustManager[] trustManagers = new TrustManager[1];
        trustManagers[0] = disabledTrustManager;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManagers, new java.security.SecureRandom());
        SSLSocketFactory disabledSSLSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(disabledSSLSocketFactory, disabledTrustManager);
        builder.hostnameVerifier(new TrustAllHostnames());
      } catch (NoSuchAlgorithmException e) {
        log.warn("Error setting SSLSocketFactory in OKHttpClient", e);
      } catch (KeyManagementException e) {
        log.warn("Error setting SSLSocketFactory in OKHttpClient", e);
      }
    }

    return builder;
  }

  private static class DisableValidationTrustManager implements X509TrustManager {

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
      return new X509Certificate[0];
    }
  }

  private static class TrustAllHostnames implements HostnameVerifier {

    @Override
    public boolean verify(String s, SSLSession sslSession) {
      return true;
    }

  }
}
