package cn.zzq0324.radish.components.http.configuration;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * OkHttp配置属性
 *
 * @author  zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "radish.http")
public class OkHttpProperties {

  /**
   * 关闭SSL校验
   */
  private boolean disableSslValidation = false;

  /**
   * 最大连接数
   */
  private int maxConnections = 100;

  /**
   * 连接保持时间，单位：毫秒
   */
  private int timeToLive = 600000;

  /**
   * 连接超时时间，单位：毫秒
   */
  private int connectionTimeout = 2000;

  /**
   * 读取超时时间，单位：毫秒
   */
  private int readTimeout = 10000;

  /**
   * 是否跟随重定向
   */
  private boolean followRedirects = false;

  /**
   * 连接失败是否重试
   */
  private boolean retryOnConnectionFailure = true;

  /**
   * 代理信息
   */
  private ProxyProperties proxy;

  @Data
  public static class ProxyProperties {

    /**
     * 代理类型，DIRECT、HTTP、SOCK
     */
    private String type;

    /**
     * 代理host
     */
    private String host;

    /**
     * 代理端口
     */
    private int port;
  }
}
