/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.http;

import cn.zzq0324.radish.common.util.MessageConvertUtils;
import cn.zzq0324.radish.components.http.util.RequestUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadishHttpClient {
    private static final Logger log = LoggerFactory.getLogger(RadishHttpClient.class);
    private OkHttpClient okHttpClient;

    public RadishHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public void call(Request request) {
        this.call(request, Void.class);
    }

    public <T> T call(Request request, Class<T> responseType) {
        try (Response response = null;){
            response = this.okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new RuntimeException("url: " + RequestUtils.getUrl(request) + " fail, status code: " + response.code());
            }
            String responseData = response.body().string();
            Object object = MessageConvertUtils.convert((String)responseData, responseType);
            return (T)object;
        }
    }
}

