/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.http.configuration;

import cn.zzq0324.radish.components.http.RadishHttpClient;
import cn.zzq0324.radish.components.http.configuration.OkHttpClientFactory;
import cn.zzq0324.radish.components.http.configuration.OkHttpProperties;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OkHttpProperties.class})
public class OkHttpAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OkHttpAutoConfiguration.class);
    private OkHttpClient okHttpClient;

    @Bean
    public RadishHttpClient radishHttpClient(OkHttpClient okHttpClient) {
        return new RadishHttpClient(okHttpClient);
    }

    @Bean
    public OkHttpClientFactory okHttpClientFactory() {
        return new OkHttpClientFactory();
    }

    @Bean
    public ConnectionPool httpClientConnectionPool(OkHttpProperties okHttpProperties) {
        int maxTotalConnections = okHttpProperties.getMaxConnections();
        long timeToLive = okHttpProperties.getTimeToLive();
        return new ConnectionPool(maxTotalConnections, timeToLive, TimeUnit.MILLISECONDS);
    }

    @Bean
    @DependsOn(value={"springContextHolder"})
    public OkHttpClient okHttpClient(OkHttpClientFactory clientFactory, ConnectionPool connectionPool, OkHttpProperties okHttpProperties, Optional<List<Interceptor>> optionalInterceptors) {
        OkHttpClient.Builder builder = clientFactory.createBuilder(okHttpProperties.isDisableSslValidation());
        this.setInterceptors(builder, optionalInterceptors);
        this.setProxy(builder, okHttpProperties.getProxy());
        this.okHttpClient = builder.connectTimeout((long)okHttpProperties.getConnectionTimeout(), TimeUnit.MILLISECONDS).followRedirects(okHttpProperties.isFollowRedirects()).readTimeout(Duration.ofMillis(okHttpProperties.getReadTimeout())).connectionPool(connectionPool).retryOnConnectionFailure(okHttpProperties.isRetryOnConnectionFailure()).build();
        return this.okHttpClient;
    }

    private void setInterceptors(OkHttpClient.Builder builder, Optional<List<Interceptor>> optionalInterceptors) {
        if (optionalInterceptors.isPresent()) {
            optionalInterceptors.get().stream().forEach(interceptor -> {
                log.info("set interceptor: {} to OkHttpClient", (Object)interceptor.getClass().getName());
                builder.addInterceptor(interceptor);
            });
        }
    }

    private void setProxy(OkHttpClient.Builder builder, OkHttpProperties.ProxyProperties proxyProperties) {
        if (proxyProperties == null || !StringUtils.hasLength((String)proxyProperties.getHost())) {
            return;
        }
        Proxy.Type proxyType = Proxy.Type.valueOf(proxyProperties.getType().toUpperCase());
        InetSocketAddress address = new InetSocketAddress(proxyProperties.getHost(), proxyProperties.getPort());
        Proxy proxy = new Proxy(proxyType, address);
        builder.proxy(proxy);
    }

    @PreDestroy
    public void destroy() {
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }
}

