package cn.zzq0324.radish.components.jwt;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * jwt属性配置
 *
 * @author zzq0324
 * @since 1.0.0
 */
@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "radish.jwt.secret")
@ConfigurationProperties(prefix = "radish.jwt")
public class JwtProperties {

  /**
   * 颁发人，默认radish
   */
  private String issuer = "radish";

  /**
   * 密钥
   */
  private String secret;

  /**
   * 过期时间，单位：秒。默认1天
   */
  private Integer expiresIn = 86400;
}
