/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.jwt;

import cn.zzq0324.radish.common.util.JsonUtils;
import cn.zzq0324.radish.components.jwt.JwtProperties;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class JwtUtils {
    public static final String CLAIM_NAME = "radishClaim";
    private static JwtProperties jwtProperties;
    private static Algorithm algorithm;

    public JwtUtils(@Autowired JwtProperties jwtProperties) {
        Assert.notNull((Object)jwtProperties, (String)"jwt properties required, please check if radish.jwt configured");
        Assert.notNull((Object)jwtProperties.getSecret(), (String)"jwt secret required.");
        JwtUtils.jwtProperties = jwtProperties;
        algorithm = Algorithm.HMAC256((String)jwtProperties.getSecret());
    }

    public static String generateToken(Map<String, Object> claims) {
        return JwtUtils.generateToken(claims, jwtProperties.getExpiresIn(), TimeUnit.SECONDS);
    }

    public static String generateToken(Map<String, Object> claims, int expire, TimeUnit timeUnit) {
        Date expireDate = JwtUtils.getExpireDate(expire, timeUnit);
        JWTCreator.Builder builder = JWT.create().withIssuer(jwtProperties.getIssuer()).withExpiresAt(expireDate);
        if (!CollectionUtils.isEmpty(claims)) {
            builder.withClaim(CLAIM_NAME, claims);
        }
        return builder.sign(algorithm);
    }

    public static Map<String, Object> verifyToken(String token) {
        DecodedJWT decodedJWT = JWT.require((Algorithm)algorithm).withIssuer(new String[]{jwtProperties.getIssuer()}).build().verify(token);
        Claim claim = decodedJWT.getClaim(CLAIM_NAME);
        if (claim != null) {
            return claim.asMap();
        }
        return null;
    }

    public static <T> T verifyToken(String token, Class<T> type) {
        Map<String, Object> claims = JwtUtils.verifyToken(token);
        return (T)JsonUtils.objectMapper().convertValue(claims, type);
    }

    public static String refreshToken(String token) {
        Map<String, Object> claims = JwtUtils.verifyToken(token);
        return JwtUtils.generateToken(claims);
    }

    private static Date getExpireDate(int expire, TimeUnit timeUnit) {
        long mills = System.currentTimeMillis() + timeUnit.toMillis(expire);
        return new Date(mills);
    }
}

