package cn.zzq0324.radish.components.uc.application.controller;

import cn.zzq0324.radish.common.dto.response.Response;
import cn.zzq0324.radish.components.uc.application.service.UserService;
import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.web.annotation.SkipInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * OAuth控制器
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@RequestMapping("/api/users")
@Controller
public class UserController {

  @Autowired
  private UserService userService;

  /**
   * 三方平台通过code授权换取令牌
   */
  @SkipInterceptor
  @GetMapping("/{type}/{appId}/oauth")
  public Response<String> code2token(@PathVariable("type") int type, @PathVariable("appId") String appId,
      @RequestParam("code") String code) {
    Platform platform = Platform.byType(type);

    // 进行oauth登录验证
    String token = userService.oauthLogin(platform, appId, code);

    return Response.ok(token);
  }
}