package cn.zzq0324.radish.components.uc.application.service;

import cn.zzq0324.radish.components.jwt.JwtUtils;
import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.components.uc.domain.service.UserDomainService;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserEntity;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserOAuthEntity;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.OAuthHandler;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.SessionInfo;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserOAuthRepository;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserRepository;
import cn.zzq0324.radish.extension.ExtensionLoader;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户service
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Service
public class UserService {

  @Autowired
  private UserOAuthRepository userOAuthRepository;

  @Autowired
  private UserRepository userRepository;

  @Autowired
  private UserDomainService userDomainService;

  public String oauthLogin(Platform platform, String appId, String code) {
    // 通过code获取三方的session信息
    SessionInfo sessionInfo = ExtensionLoader.getExtension(OAuthHandler.class, platform.getExtName())
        .codeToSession(appId, code);

    UserEntity userEntity = getOrRegister(platform, sessionInfo);

    return generateToken(userEntity);
  }

  private UserEntity getOrRegister(Platform platform, SessionInfo sessionInfo) {
    UserOAuthEntity userOAuthEntity = userOAuthRepository.getByOpenId(sessionInfo.getOpenId());

    // 已注册，直接查询
    if (userOAuthEntity != null) {
      return userRepository.getById(userOAuthEntity.getUserId());
    }

    // 未注册，先注册再返回
    return userDomainService.oauthRegister(platform, sessionInfo);
  }

  private String generateToken(UserEntity userEntity) {
    Map<String, Object> claims = new HashMap<>();
    claims.put("userId", userEntity.getId());

    return JwtUtils.generateToken(claims);
  }
}
