package cn.zzq0324.radish.components.uc.constant;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

/**
 * 平台枚举
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
public enum Platform {

  OFFICIAL_ACCOUNT(1, PlatformConstants.EXT_NAME_OFFICIAL_ACCOUNT, "微信公众号"),
  WX_MINI_PROGRAM(2, PlatformConstants.EXT_NAME_WECHAT_MINI_PROGRAM, "微信小程序");

  /**
   * 平台类型
   */
  @EnumValue
  @JsonValue
  private int type;

  /**
   * 扩展点名称
   */
  private String extName;

  /**
   * 平台名称
   */
  private String name;

  Platform(int type, String extName, String name) {
    this.type = type;
    this.name = name;
    this.extName = extName;
  }

  public String getExtName() {
    return extName;
  }

  public static Platform byType(int type) {
    for (Platform platform : values()) {
      if (Objects.equals(platform.type, type)) {
        return platform;
      }
    }

    throw new IllegalArgumentException("unknown platform type: " + type);
  }
}