package cn.zzq0324.radish.components.uc.context;

/**
 * 请求上下文
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
public class RequestContext {

  private static ThreadLocal<RequestContext> context = ThreadLocal.withInitial(RequestContext::new);

  private Long userId;

  public static RequestContext getContext() {
    return context.get();
  }

  public static void setContext(RequestContext requestContext) {
    context.set(requestContext);
  }

  public static void remove() {
    context.remove();
  }

  public static Long getUserId() {
    return context.get().userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }
}
