package cn.zzq0324.radish.components.uc.context;

import cn.zzq0324.radish.common.exception.UnauthorizedException;
import cn.zzq0324.radish.components.jwt.JwtUtils;
import cn.zzq0324.radish.web.annotation.Interceptor;
import cn.zzq0324.radish.web.uitl.InterceptorUtils;
import com.auth0.jwt.interfaces.DecodedJWT;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 请求上下文拦截器
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Slf4j
@Interceptor(includePaths = {"/api/*"})
public class RequestContextInterceptor implements HandlerInterceptor {

  @Override
  public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    if (InterceptorUtils.annotateSkipInterceptor(handler)) {
      return true;
    }

    // 进行token校验，校验成功后设置到上下文信息；校验不成功抛出未授权，返回401
    try {
      String token = request.getHeader(HttpHeaders.AUTHORIZATION);
      DecodedJWT decodedJWT = JwtUtils.verifyToken(token);
      Long userId = decodedJWT.getClaim("userId").asLong();

      RequestContext requestContext = new RequestContext();
      requestContext.setUserId(userId);
      RequestContext.setContext(requestContext);
    } catch (Exception e) {
      log.warn("verify token failure", e);

      throw new UnauthorizedException();
    }

    return true;
  }

  @Override
  public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    // 清空上下文信息，避免内存泄露
    RequestContext.remove();
  }
}
