package cn.zzq0324.radish.components.uc.domain.service;

import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserEntity;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserOAuthEntity;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.SessionInfo;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserOAuthRepository;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 用户领域service
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Slf4j
@Service
public class UserDomainService {

  @Autowired
  private UserRepository userRepository;

  @Autowired
  private UserOAuthRepository userOAuthRepository;

  @Transactional
  public UserEntity oauthRegister(Platform platform, SessionInfo sessionInfo) {
    UserEntity userEntity = new UserEntity();
    userEntity.setAvatar(sessionInfo.getAvatar());
    userEntity.setMobile(sessionInfo.getMobile());
    userEntity.setNickName(sessionInfo.getNickName());
    userEntity.setRegisterPlatform(platform);
    userRepository.save(userEntity);

    UserOAuthEntity userOAuthEntity = new UserOAuthEntity();
    userOAuthEntity.setPlatform(platform);
    userOAuthEntity.setUserId(userEntity.getId());
    userOAuthEntity.setOpenId(sessionInfo.getOpenId());
    userOAuthEntity.setToken(sessionInfo.getToken());
    userOAuthEntity.setUnionId(sessionInfo.getUnionId());
    userOAuthRepository.save(userOAuthEntity);

    log.info("user: {} from platform: {} register successfully.", userEntity.getId(), platform);

    return userEntity;
  }
}
