package cn.zzq0324.radish.components.uc.infrastructure.entity;

import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.data.mybatis.entity.Entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * 用户OAuth授权实体
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Getter
@Setter
@TableName("user_oauth")
public class UserOAuthEntity extends Entity<Long> {

  /**
   * 用户id，对应
   */
  private Long userId;

  /**
   * 平台
   */
  private Platform platform;

  /**
   * 用户级别token
   */
  @TableField("token")
  private String token;

  /**
   * 用户OpenID
   */
  @TableField("open_id")
  private String openId;

  /**
   * 用户UnionId
   */
  @TableField("union_id")
  private String unionId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT, value = "create_time")
  protected LocalDateTime createTime;
}
