package cn.zzq0324.radish.components.uc.infrastructure.oauth;

import cn.zzq0324.radish.components.wechat.WechatApiFactory;
import cn.zzq0324.radish.components.wechat.miniprogram.api.UserApi;
import cn.zzq0324.radish.components.wechat.miniprogram.dto.JsCodeToSessionResponse;
import cn.zzq0324.radish.extension.annotation.Extension;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

/**
 * 微信小程序扩展实现
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@ConditionalOnClass(WechatApiFactory.class)
@Extension(scenario = "wechatMiniProgram", desc = "微信小程序OAuth授权")
public class WechatMiniProgramOAuthHandler implements OAuthHandler {

  @Override
  public SessionInfo codeToSession(String appId, String code) {
    UserApi userApi = WechatApiFactory.miniProgram().userApi(appId);

    JsCodeToSessionResponse response = userApi.jsCodeToSession(code);

    return null;
  }
}
