package cn.zzq0324.radish.components.uc.infrastructure.repository;

import cn.zzq0324.radish.components.uc.infrastructure.entity.UserOAuthEntity;
import cn.zzq0324.radish.components.uc.infrastructure.repository.mapper.UserOAuthMapper;
import cn.zzq0324.radish.data.mybatis.repository.AbstractRepository;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;

/**
 * 用户oauth repository
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Service
public class UserOAuthRepository extends AbstractRepository<UserOAuthMapper, UserOAuthEntity> {

  /**
   * 根据openId查询授权记录
   */
  public UserOAuthEntity getByOpenId(String openId) {
    LambdaQueryWrapper<UserOAuthEntity> wrapper = new LambdaQueryWrapper<>();
    wrapper.eq(UserOAuthEntity::getOpenId, openId);

    return baseMapper.selectOne(wrapper);
  }
}
