/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.uc.application.service;

import cn.zzq0324.radish.components.jwt.JwtUtils;
import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.components.uc.domain.service.UserDomainService;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserEntity;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserOAuthEntity;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.OAuthHandler;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.SessionInfo;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserOAuthRepository;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserRepository;
import cn.zzq0324.radish.extension.ExtensionLoader;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    private UserOAuthRepository userOAuthRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserDomainService userDomainService;

    public String oauthLogin(Platform platform, String appId, String code) {
        SessionInfo sessionInfo = ((OAuthHandler)ExtensionLoader.getExtension(OAuthHandler.class, (String)platform.getExtName())).codeToSession(appId, code);
        UserEntity userEntity = this.getOrRegister(platform, sessionInfo);
        return this.generateToken(userEntity);
    }

    private UserEntity getOrRegister(Platform platform, SessionInfo sessionInfo) {
        UserOAuthEntity userOAuthEntity = this.userOAuthRepository.getByOpenId(sessionInfo.getOpenId());
        if (userOAuthEntity != null) {
            return (UserEntity)((Object)this.userRepository.getById(userOAuthEntity.getUserId()));
        }
        return this.userDomainService.oauthRegister(platform, sessionInfo);
    }

    private String generateToken(UserEntity userEntity) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("userId", userEntity.getId());
        return JwtUtils.generateToken(claims);
    }
}

