/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.uc.context;

import cn.zzq0324.radish.common.exception.UnauthorizedException;
import cn.zzq0324.radish.components.jwt.JwtUtils;
import cn.zzq0324.radish.components.uc.context.RequestContext;
import cn.zzq0324.radish.web.annotation.Interceptor;
import cn.zzq0324.radish.web.uitl.InterceptorUtils;
import com.auth0.jwt.interfaces.DecodedJWT;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

@Interceptor(includePaths={"/api/*"})
public class RequestContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestContextInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (InterceptorUtils.annotateSkipInterceptor((Object)handler)) {
            return true;
        }
        try {
            String token = request.getHeader("Authorization");
            DecodedJWT decodedJWT = JwtUtils.verifyToken((String)token);
            Long userId = decodedJWT.getClaim("userId").asLong();
            RequestContext requestContext = new RequestContext();
            requestContext.setUserId(userId);
            RequestContext.setContext(requestContext);
        }
        catch (Exception e) {
            log.warn("verify token failure", (Throwable)e);
            throw new UnauthorizedException();
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        RequestContext.remove();
    }
}

