/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.uc.domain.service;

import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserEntity;
import cn.zzq0324.radish.components.uc.infrastructure.entity.UserOAuthEntity;
import cn.zzq0324.radish.components.uc.infrastructure.oauth.SessionInfo;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserOAuthRepository;
import cn.zzq0324.radish.components.uc.infrastructure.repository.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDomainService {
    private static final Logger log = LoggerFactory.getLogger(UserDomainService.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserOAuthRepository userOAuthRepository;

    @Transactional
    public UserEntity oauthRegister(Platform platform, SessionInfo sessionInfo) {
        UserEntity userEntity = new UserEntity();
        userEntity.setAvatar(sessionInfo.getAvatar());
        userEntity.setMobile(sessionInfo.getMobile());
        userEntity.setNickName(sessionInfo.getNickName());
        userEntity.setRegisterPlatform(platform);
        this.userRepository.save((Object)userEntity);
        UserOAuthEntity userOAuthEntity = new UserOAuthEntity();
        userOAuthEntity.setPlatform(platform);
        userOAuthEntity.setUserId((Long)userEntity.getId());
        userOAuthEntity.setOpenId(sessionInfo.getOpenId());
        userOAuthEntity.setToken(sessionInfo.getToken());
        userOAuthEntity.setUnionId(sessionInfo.getUnionId());
        this.userOAuthRepository.save((Object)userOAuthEntity);
        log.info("user: {} from platform: {} register successfully.", userEntity.getId(), (Object)platform);
        return userEntity;
    }
}

