/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.uc.application.controller;

import cn.zzq0324.radish.common.dto.response.Response;
import cn.zzq0324.radish.components.uc.application.dto.ModifyUserRequest;
import cn.zzq0324.radish.components.uc.application.dto.OAuthLoginVO;
import cn.zzq0324.radish.components.uc.application.service.UserService;
import cn.zzq0324.radish.components.uc.constant.Platform;
import cn.zzq0324.radish.context.RequestContext;
import cn.zzq0324.radish.web.annotation.SkipInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1/users"})
@RestController
public class UserController {
    @Autowired
    private UserService userService;

    @SkipInterceptor
    @GetMapping(value={"/{type}/{appId}/oauth"})
    public Response<OAuthLoginVO> code2token(@PathVariable(value="type") int type, @PathVariable(value="appId") String appId, @RequestParam(value="code") String code) {
        Platform platform = Platform.byType(type);
        OAuthLoginVO oAuthLoginVO = this.userService.oauthLogin(platform, appId, code);
        return Response.ok((Object)oAuthLoginVO);
    }

    @PutMapping(value={"/{userId}/basic_info"})
    @ResponseBody
    public Response<Void> modify(@PathVariable(value="userId") Long userId, @RequestBody ModifyUserRequest request) {
        this.userService.modify(RequestContext.getUserId(), request);
        return Response.ok();
    }
}

