/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.uc.context;

import cn.zzq0324.radish.common.exception.UnauthorizedException;
import cn.zzq0324.radish.components.jwt.JwtUtils;
import cn.zzq0324.radish.context.RequestContext;
import cn.zzq0324.radish.web.annotation.Interceptor;
import cn.zzq0324.radish.web.uitl.InterceptorUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;

@Interceptor(includePaths={"/api/**"})
@Order(value=-2147483638)
public class RequestContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestContextInterceptor.class);
    public static final String AUTH_TOKEN = "x-auth-token";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (InterceptorUtils.annotateSkipInterceptor((Object)handler)) {
            return true;
        }
        try {
            String token = request.getHeader(AUTH_TOKEN);
            Map sessionMap = JwtUtils.verifyToken((String)token);
            Long userId = Long.parseLong(sessionMap.get("userId").toString());
            RequestContext requestContext = new RequestContext();
            requestContext.setUserId(userId);
            requestContext.setClaims(sessionMap);
            RequestContext.setContext((RequestContext)requestContext);
        }
        catch (Exception e) {
            log.warn("verify token failure", (Throwable)e);
            throw new UnauthorizedException();
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        RequestContext.remove();
    }
}

