/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.configuration;

import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.web.annotation.Interceptor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={SpringContextHolder.class})
public class RadishWebAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RadishWebAutoConfiguration.class);
    public static final List<String> COMMON_EXCLUDE_PATHS = Arrays.asList("/actuator/**", "/swagger-ui/index.html", "/swagger-ui.html");
    @Autowired
    private Optional<List<HandlerInterceptor>> optionalList;

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.optionalList.get() == null) {
            return;
        }
        this.optionalList.get().forEach(interceptor -> {
            InterceptorRegistration registration = registry.addInterceptor(interceptor);
            registration.excludePathPatterns(COMMON_EXCLUDE_PATHS);
            Interceptor interceptorAnnotation = (Interceptor)AnnotationUtils.findAnnotation(interceptor.getClass(), Interceptor.class);
            if (interceptorAnnotation != null) {
                this.addExcludePathsFromAnnotation(interceptorAnnotation, registration);
                this.addIncludePathsFromAnnotation(interceptorAnnotation, registration);
            }
            log.info("interceptor: {} added to InterceptorRegistry successfully", (Object)interceptor.getClass().getName());
        });
    }

    private void addExcludePathsFromAnnotation(Interceptor interceptorAnnotation, InterceptorRegistration registration) {
        if (interceptorAnnotation.excludePaths() != null && interceptorAnnotation.excludePaths().length > 0) {
            registration.excludePathPatterns(interceptorAnnotation.excludePaths());
        }
    }

    private void addIncludePathsFromAnnotation(Interceptor interceptorAnnotation, InterceptorRegistration registration) {
        if (interceptorAnnotation.includePaths() != null && interceptorAnnotation.includePaths().length > 0) {
            registration.addPathPatterns(interceptorAnnotation.includePaths());
        }
    }
}

