/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.handler;

import cn.zzq0324.radish.common.code.CommonStatusCode;
import cn.zzq0324.radish.common.code.StatusCode;
import cn.zzq0324.radish.common.dto.response.Response;
import cn.zzq0324.radish.common.exception.BusinessException;
import cn.zzq0324.radish.common.exception.PermissionDeniedException;
import cn.zzq0324.radish.common.exception.UnauthorizedException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
@Order(value=-2147483648)
@ConditionalOnProperty(value={"radish.web.exception-handler.enable"}, havingValue="true", matchIfMissing=true)
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Response handleArgumentTypeMismatch(MethodArgumentTypeMismatchException e, HttpServletRequest request) {
        log.warn("argument type mismatch, request url: {}", (Object)this.getRequestURL(request), (Object)e);
        return Response.with((StatusCode)CommonStatusCode.BAD_REQUEST.args(new Object[]{e.getName(), e.getRequiredType()}));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Response handleMethodArgumentNotValidException(MethodArgumentNotValidException e, HttpServletRequest request) {
        log.warn("request url: {}, method argument not valid.", (Object)this.getRequestURL(request), (Object)e);
        String error = e.getBindingResult().getAllErrors().stream().map(s -> s.getDefaultMessage()).collect(Collectors.joining(";"));
        return Response.with((StatusCode)CommonStatusCode.BAD_REQUEST.args(new Object[]{error}));
    }

    @ExceptionHandler(value={ValidationException.class})
    public Response handleValidationException(ValidationException e, HttpServletRequest request) {
        log.warn("request url: {}, argument not valid.", (Object)this.getRequestURL(request), (Object)e);
        return Response.with((StatusCode)CommonStatusCode.BAD_REQUEST.args(new Object[]{e.getMessage()}));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Response handleIllegalArgumentException(IllegalArgumentException e, HttpServletRequest request) {
        log.warn("request url: {}, illegal argument: {}", (Object)this.getRequestURL(request), (Object)e);
        return Response.with((StatusCode)CommonStatusCode.BAD_REQUEST.args(new Object[]{e.getMessage()}));
    }

    @ExceptionHandler(value={BusinessException.class})
    public Response handleBusinessException(BusinessException e, HttpServletRequest request) {
        log.warn("request url: {}, error code: {}", new Object[]{this.getRequestURL(request), e.getStatusCode(), e});
        return Response.with((StatusCode)e.getStatusCode());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public void handleUnauthorizedException(UnauthorizedException e, HttpServletRequest request) {
        log.warn("request url: {} unauthorized", (Object)this.getRequestURL(request), (Object)e);
    }

    @ExceptionHandler(value={PermissionDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public void handlePermissionDeniedException(PermissionDeniedException e, HttpServletRequest request) {
        log.error("request url: {} forbidden", (Object)this.getRequestURL(request), (Object)e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleNoHandlerFoundException(HttpServletRequest request) {
        log.error("not handler found, request method: {}, url: {}.", (Object)request.getMethod(), (Object)request.getRequestURL());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Response handleRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String supportedMethods = Arrays.toString(e.getSupportedMethods());
        log.warn("request method not supported. request url: {}, request method:{}, support method:{}", new Object[]{request.getRequestURL(), e.getMethod(), supportedMethods});
        return Response.with((StatusCode)CommonStatusCode.METHOD_NOT_SUPPORT.args(new Object[]{request.getMethod(), supportedMethods}));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Response handleMediaTypeNotSupported(HttpMediaTypeNotSupportedException e, HttpServletRequest request) {
        log.warn("media type not supported, request url: {}, content type: {}", new Object[]{request.getRequestURL(), request.getContentType(), e});
        return Response.with((StatusCode)CommonStatusCode.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Response handleMissingServletRequestParameterException(MissingServletRequestParameterException e, HttpServletRequest request) {
        log.warn("request url: {}, request param missing exception.", (Object)request.getRequestURL(), (Object)e);
        return Response.with((StatusCode)CommonStatusCode.BAD_REQUEST.args(new Object[]{e.getMessage()}));
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void handleUnknownException(Throwable e, HttpServletRequest request) {
        log.error("unknown exception occur, request url: {}", (Object)this.getRequestURL(request), (Object)e);
    }

    private String getRequestURL(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }
}

