/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.i18n;

import cn.zzq0324.radish.common.dto.response.Response;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.MessageSource;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=20)
@ConditionalOnProperty(value={"spring.messages.basename"})
@ConditionalOnBean(value={MessageSource.class})
@RestControllerAdvice
public class InternationalResponseAdvice
implements ResponseBodyAdvice<Response> {
    private static final Logger log = LoggerFactory.getLogger(InternationalResponseAdvice.class);
    private static final String I18N_STATUS_CODE = "code.%d";
    @Autowired(required=false)
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        Method method = methodParameter.getMethod();
        if (method == null) {
            return false;
        }
        return Response.class.getName().equalsIgnoreCase(method.getReturnType().getName());
    }

    public Response beforeBodyWrite(Response body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (this.messageSource == null) {
            return body;
        }
        return body;
    }
}

