/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.log;

import cn.zzq0324.radish.web.log.AccessLogger;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;

@Component
@ConditionalOnProperty(value={"radish.web.access-log.enable"}, havingValue="true", matchIfMissing=true)
public class AccessLogFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ContentCachingRequestWrapper requestWrapper = this.wrapRequest(request);
        AccessLogger accessLogger = new AccessLogger(request);
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
        }
        finally {
            accessLogger.log(request, response);
        }
    }

    private ContentCachingRequestWrapper wrapRequest(HttpServletRequest request) {
        if (request instanceof ContentCachingRequestWrapper) {
            return (ContentCachingRequestWrapper)request;
        }
        return new ContentCachingRequestWrapper(request);
    }
}

