/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.log;

import cn.zzq0324.radish.common.util.DateUtils;
import cn.zzq0324.radish.common.util.StrUtils;
import cn.zzq0324.radish.web.annotation.SkipLogRequestData;
import cn.zzq0324.radish.web.log.AccessLog;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class AccessLogger {
    private static final Logger log = LoggerFactory.getLogger(AccessLogger.class);
    private static final Logger BIZ_LOGGER = LoggerFactory.getLogger(AccessLog.class);
    private static final ThreadLocal<AccessLogger> LOG_CONTEXT = new ThreadLocal();
    public static final String AND_SYMBOL = "&";
    public static final String EQUAL_SYMBOL = "=";
    private static final String HANDLER_FORMAT = "%s-%s";
    private static final String LOG_SPLITTER = " | ";
    protected AccessLog accessLog;

    public AccessLogger(HttpServletRequest request) {
        this.initAccessLog(request);
        LOG_CONTEXT.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!this.isSkipRequestData(request)) {
                this.accessLog.setRequestData(this.getRequestData(request));
            }
            this.accessLog.setUrlPattern(this.getPathPattern(request));
            this.accessLog.setHandler(this.getHandler(request));
            this.accessLog.setHttpStatusCode(response.getStatus());
            this.accessLog.setException(this.getException(request));
            this.accessLog.setElapsed(System.currentTimeMillis() - this.accessLog.getCreateTime().getTime());
            log.info(this.buildLog());
        }
        catch (Exception e) {
            BIZ_LOGGER.error("record access log error", (Throwable)e);
        }
        finally {
            LOG_CONTEXT.remove();
        }
    }

    private String buildLog() {
        StringBuilder logBuilder = new StringBuilder();
        String exceptionName = "-";
        if (this.accessLog.getException() != null) {
            exceptionName = this.accessLog.getException().getClass().getName();
        }
        logBuilder.append(DateUtils.format((String)"yyyy-MM-dd HH:mm:ss.SSS", (Date)this.accessLog.getCreateTime())).append(LOG_SPLITTER).append(StrUtils.emptyToDash((String)this.accessLog.getClientIp())).append(LOG_SPLITTER).append(this.accessLog.getHttpMethod()).append(LOG_SPLITTER).append(this.accessLog.getRequestUri()).append(LOG_SPLITTER).append(this.accessLog.getUrlPattern()).append(LOG_SPLITTER).append(this.accessLog.getUserAgent()).append(LOG_SPLITTER).append(this.accessLog.getHandler()).append(LOG_SPLITTER).append(this.accessLog.getElapsed()).append(LOG_SPLITTER).append(this.accessLog.getHttpStatusCode()).append(LOG_SPLITTER).append(StrUtils.removeLineBreak((String)StrUtils.emptyToDash((String)this.accessLog.getRequestData()))).append(LOG_SPLITTER).append(exceptionName);
        Map<String, String> context = this.accessLog.getContext();
        if (context != null) {
            for (Map.Entry<String, String> entry : context.entrySet()) {
                logBuilder.append(LOG_SPLITTER).append(entry.getKey()).append('=').append(entry.getValue());
            }
        }
        return logBuilder.toString();
    }

    public static AccessLogger getLogger() {
        return LOG_CONTEXT.get();
    }

    public void logContext(String key, String value) {
        if (this.accessLog.getContext() == null) {
            this.accessLog.setContext(new HashMap<String, String>());
        }
        this.accessLog.getContext().put(key, StrUtils.removeLineBreak((String)value));
    }

    private String getHandler(HttpServletRequest request) {
        HandlerMethod handlerMethod = this.getHandlerMethod(request);
        if (handlerMethod == null) {
            return null;
        }
        String controllerName = handlerMethod.getBeanType().getSimpleName();
        String methodName = handlerMethod.getMethod().getName();
        return String.format(HANDLER_FORMAT, controllerName, methodName);
    }

    private String getPathPattern(HttpServletRequest request) {
        Object urlPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (urlPattern != null) {
            return (String)urlPattern;
        }
        return null;
    }

    private Throwable getException(HttpServletRequest request) {
        Object exception = request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
        if (exception instanceof Throwable) {
            return (Throwable)exception;
        }
        return null;
    }

    private boolean isSkipRequestData(HttpServletRequest request) {
        HandlerMethod handlerMethod = this.getHandlerMethod(request);
        if (handlerMethod == null) {
            return true;
        }
        return handlerMethod.getMethod().isAnnotationPresent(SkipLogRequestData.class) || handlerMethod.getBeanType().isAnnotationPresent(SkipLogRequestData.class);
    }

    private HandlerMethod getHandlerMethod(HttpServletRequest request) {
        Object handlerObj = request.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
        if (handlerObj instanceof HandlerMethod) {
            return (HandlerMethod)handlerObj;
        }
        return null;
    }

    private String getRequestData(HttpServletRequest request) {
        if (!(request instanceof ContentCachingRequestWrapper)) {
            return null;
        }
        ContentCachingRequestWrapper requestWrapper = (ContentCachingRequestWrapper)request;
        if (request.getContentLength() > 0) {
            return new String(requestWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
        }
        return this.buildParameterValue(requestWrapper);
    }

    private void initAccessLog(HttpServletRequest request) {
        this.accessLog = new AccessLog();
        this.accessLog.setCreateTime(new Date());
        this.accessLog.setHttpMethod(request.getMethod());
        this.accessLog.setClientIp(request.getRemoteAddr());
        this.accessLog.setRequestUri(request.getRequestURI());
        this.accessLog.setUserAgent(request.getHeader("User-Agent"));
    }

    private String buildParameterValue(ContentCachingRequestWrapper request) {
        Enumeration paramNames = request.getParameterNames();
        if (paramNames == null || !paramNames.hasMoreElements()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (paramNames.hasMoreElements()) {
            if (builder.length() > 0) {
                builder.append(AND_SYMBOL);
            }
            String paramName = (String)paramNames.nextElement();
            String value = request.getParameter(paramName);
            builder.append(paramName).append(EQUAL_SYMBOL).append(value);
        }
        return builder.toString();
    }
}

