/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.web.uitl;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpRequestUtils {
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    public static String getClientIP() {
        if (RequestContextHolder.getRequestAttributes() == null || !(RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes)) {
            return "0.0.0.0";
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        for (String header : IP_HEADER_CANDIDATES) {
            String ipList = request.getHeader(header);
            if (!StringUtils.hasLength((String)ipList) || "unknown".equalsIgnoreCase(ipList)) continue;
            return ipList.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

