package cn.zzq0324.radish.components.wechat;

import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.config.WechatAppProperties;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.officialaccount.api.MenuApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.MessageApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.TokenApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.UserApi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.ConcurrentLruCache;

/**
 * 微信API工厂类
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class WechatApiFactory {

  private static OfficialAccountApi officialAccountApi = new OfficialAccountApi();
  private static MiniProgramApi miniProgramApi = new MiniProgramApi();

  protected static WechatAppProperties wechatAppProperties = SpringContextHolder.getBean(WechatAppProperties.class);

  // 缓存API类，减少重复创建
  protected static ConcurrentLruCache<String, Map<Class, Object>> API_CACHE = new ConcurrentLruCache<>(1024,
      appId -> new ConcurrentHashMap<>());

  public static OfficialAccountApi officialAccount() {
    return officialAccountApi;
  }

  public static MiniProgramApi miniProgram() {
    return miniProgramApi;
  }

  public static class OfficialAccountApi {

    public TokenApi tokenApi(String appId) {
      return getInstance(appId, TokenApi.class);
    }

    public UserApi userApi(String appId) {
      return getInstance(appId, UserApi.class);
    }

    public MenuApi menuApi(String appId) {
      return getInstance(appId, MenuApi.class);
    }

    public MessageApi messageApi(String appId) {
      return getInstance(appId, MessageApi.class);
    }
  }

  public static class MiniProgramApi {

    public static cn.zzq0324.radish.components.wechat.miniprogram.api.UserApi userApi(String appId) {
      return getInstance(appId, cn.zzq0324.radish.components.wechat.miniprogram.api.UserApi.class);
    }
  }

  private static <T extends BaseApi> T getInstance(String appId, Class<T> type) {
    Map<Class, Object> apiMap = API_CACHE.get(appId);

    return (T) apiMap.computeIfAbsent(type, apiType -> BaseApi.newInstance(getAppInfo(appId), apiType));
  }

  private static AppInfo getAppInfo(String appId) {
    AppInfo appInfo = wechatAppProperties.getApps().get(appId);

    if (appInfo == null) {
      throw new UnsupportedOperationException("appId: " + appId + " not configured.");
    }

    return appInfo;
  }
}
