package cn.zzq0324.radish.components.wechat.common;

import cn.zzq0324.radish.components.wechat.WechatApiFactory;
import cn.zzq0324.radish.components.wechat.dto.AccessToken;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.GetAccessTokenResponse;
import java.util.Date;
import lombok.extern.slf4j.Slf4j;

/**
 * 令牌生成器
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Slf4j
public class AccessTokenGenerator {

  /**
   * 根据应用信息生成token
   */
  public static AccessToken generate(AppInfo appInfo) {
    GetAccessTokenResponse response = WechatApiFactory.officialAccount().tokenApi(appInfo.getAppId()).getAccessToken();

    log.info("appId: {} generate token successfully.", appInfo);

    return new AccessToken(new Date(), response.getAccessToken());
  }
}
