package cn.zzq0324.radish.components.wechat.common;

import cn.zzq0324.radish.components.wechat.dto.AccessToken;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import java.util.concurrent.TimeUnit;
import org.springframework.util.ConcurrentLruCache;

/**
 * 令牌信息
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class AccessTokenHolder {

  // 只保留1024个App的token信息，超过不保存
  private static ConcurrentLruCache<AppInfo, AccessToken> TOKEN_CACHE = new ConcurrentLruCache<>(1024,
      appInfo -> AccessTokenGenerator.generate(appInfo));

  public static AccessToken get(AppInfo appInfo) {
    AccessToken accessToken = TOKEN_CACHE.get(appInfo);

    if (accessToken != null && isAccessTokenExpired(appInfo, accessToken)) {
      synchronized (appInfo) {
        // 再次获取并确认是否过期，如果不过期直接返回，如果过期再清除，避免并发下重复移除未过期的token
        accessToken = TOKEN_CACHE.get(appInfo);
        if (isAccessTokenExpired(appInfo, accessToken)) {
          TOKEN_CACHE.remove(appInfo);
          accessToken = TOKEN_CACHE.get(appInfo);
        }
      }
    }

    return accessToken;
  }

  /**
   * 判断access token是否过期
   */
  private static boolean isAccessTokenExpired(AppInfo appInfo, AccessToken accessToken) {
    long expireMills = accessToken.getGenerateTime().getTime() + TimeUnit.SECONDS.toMillis(appInfo.getTimeToLive());

    return expireMills <= System.currentTimeMillis();
  }
}
