package cn.zzq0324.radish.components.wechat.config;

import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

/**
 * 微信公众号和小程序配置属性
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@Configuration
@ConditionalOnProperty(value = "radish.wechat.enable", havingValue = "true")
@ConfigurationProperties(prefix = "radish.wechat")
public class WechatAppProperties {

  /**
   * access token令牌存活时间，单位：秒
   */
  private Integer accessTokenTimeToLive = 270;

  /**
   * 应用配置
   */
  private Map<String, AppInfo> apps;

  @PostConstruct
  public void initApps() {
    if (CollectionUtils.isEmpty(apps)) {
      return;
    }

    apps.keySet().forEach(appId -> {
      AppInfo appInfo = apps.get(appId);
      appInfo.setAppId(appId);
      appInfo.setTimeToLive(accessTokenTimeToLive);
    });
  }
}
