package cn.zzq0324.radish.components.wechat.dto;

import cn.zzq0324.radish.components.wechat.constant.AppType;
import java.util.Objects;
import lombok.Getter;
import lombok.Setter;

/**
 * App信息，详见https://developers.weixin.qq.com/doc/offiaccount/Basic_Information/Access_Overview.html
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public class AppInfo {

  /**
   * 应用ID
   */
  private String appId;

  /**
   * 应用类型，公众号或小程序
   */
  private AppType type;

  /**
   * Token可由开发者可以任意填写，用作生成签名（该 Token 会和接口 URL 中包含的 Token 进行比对，从而验证安全性）
   */
  private String token;

  /**
   * 密钥
   */
  private String secret;

  /**
   * 加密密钥，由开发者手动填写或随机生成，将用作消息体加解密密钥
   */
  private String encodingAesKey;

  /**
   * token存活时间，默认270秒。按照官方文档，多节点重复生成token的话会导致原来的token在5分钟后不可用，如果没有中控服务器该值最好小于5分钟
   */
  private Integer timeToLive = 270;

  @Override
  public String toString() {
    return appId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    AppInfo appInfo = (AppInfo) o;
    return appId.equals(appInfo.appId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId);
  }
}
