package cn.zzq0324.radish.components.wechat.miniprogram.api;

import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.constant.MiniProgramUrls;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.miniprogram.dto.GetPhoneNumberRequest;
import cn.zzq0324.radish.components.wechat.miniprogram.dto.GetPhoneNumberResponse;
import cn.zzq0324.radish.components.wechat.miniprogram.dto.JsCodeToSessionRequest;
import cn.zzq0324.radish.components.wechat.miniprogram.dto.JsCodeToSessionResponse;

/**
 * 用户Api
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class UserApi extends BaseApi {

  public UserApi(AppInfo appInfo) {
    super(appInfo);
  }

  /**
   * jscode转sesion，完成登录流程
   * <p>
   * https://developers.weixin.qq.com/miniprogram/dev/OpenApiDoc/user-login/code2Session.html
   */
  public JsCodeToSessionResponse jsCodeToSession(String jsCode) {
    JsCodeToSessionRequest request = JsCodeToSessionRequest.builder().appId(appInfo.getAppId()).secret(
        appInfo.getSecret()).jsCode(jsCode).build();

    return execute(MiniProgramUrls.JS_CODE_TO_SESSION, HttpMethodType.GET, request, JsCodeToSessionResponse.class,
        false);
  }

  /**
   * 根据code查询用户手机号
   * <p>
   * https://developers.weixin.qq.com/miniprogram/dev/OpenApiDoc/user-info/phone-number/getPhoneNumber.html
   */
  public GetPhoneNumberResponse getPhoneNumber(String code) {
    GetPhoneNumberRequest request = GetPhoneNumberRequest.builder().code(code).build();

    return execute(MiniProgramUrls.GET_PHONE_NUMBER, HttpMethodType.GET, request, GetPhoneNumberResponse.class);
  }
}
