package cn.zzq0324.radish.components.wechat.miniprogram.dto;

import cn.zzq0324.radish.components.wechat.dto.CommonResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 查询用户手机号
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public class GetPhoneNumberResponse extends CommonResponse {

  @JsonProperty("phone_info")
  private PhoneInfo phoneInfo;

  @Getter
  @Setter
  public static class PhoneInfo {

    /**
     * 用户绑定的手机号（国外手机号会有区号）
     */
    private String phoneNumber;

    /**
     * 没有区号的手机号
     */
    private String purePhoneNumber;

    /**
     * 区号
     */
    private String countryCode;

    /**
     * 数据水印
     */
    private Watermark watermark;
  }

  @Getter
  @Setter
  public static class Watermark {

    /**
     * 用户获取手机号操作的时间戳
     */
    private Long timestamp;

    /**
     * 小程序appid
     */
    @JsonProperty("appid")
    private String appId;
  }
}
