package cn.zzq0324.radish.components.wechat.miniprogram.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * js code转session
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@Builder
public class JsCodeToSessionRequest {

  /**
   * 公众号的唯一标识
   */
  @JsonProperty("appid")
  private String appId;

  /**
   * 公众号的app secret
   */
  private String secret;

  /**
   * 登录时获取的 code，可通过wx.login获取
   */
  @JsonProperty("js_code")
  private String jsCode;

  /**
   *
   */
  @JsonProperty("grant_type")
  private String grantType = "authorization_code";
}
