package cn.zzq0324.radish.components.wechat.officialaccount.api;

import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.constant.OfficialAccountUrls;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.dto.CommonResponse;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.menu.CreateMenuRequest;

/**
 * 菜单api
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class MenuApi extends BaseApi {

  public MenuApi(AppInfo appInfo) {
    super(appInfo);
  }

  /**
   * 创建菜单，重复创建会覆盖(相当于编辑)
   */
  public CommonResponse create(CreateMenuRequest request) {
    return execute(OfficialAccountUrls.CREATE_MENU, HttpMethodType.POST_APPLICATION, request, CommonResponse.class);
  }
}
