package cn.zzq0324.radish.components.wechat.officialaccount.api;

import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.constant.OfficialAccountUrls;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.message.TemplateMessageRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.message.TemplateMessageResponse;

/**
 * 消息相关Api
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class MessageApi extends BaseApi {

  public MessageApi(AppInfo appInfo) {
    super(appInfo);
  }

  /**
   * 发送模板消息
   */
  public TemplateMessageResponse sendTemplateMessage(TemplateMessageRequest request) {
    return execute(OfficialAccountUrls.SEND_TEMPLATE_MESSAGE, HttpMethodType.POST_FORM, request,
        TemplateMessageResponse.class);
  }
}
